definition module _SystemDynamic

from StdFile import ::Files, class FileSystem
//from StdDynamicLowLevelInterface import ::RunTimeIDW
import StdDynamicLowLevelInterface
import StdDynamicTypes

import DynamicLinkerInterface

// Type of a dynamic (internal, change also convertDynamic.icl and overloading.icl)
// ----------------------------------------------------------------------------------------------------------------------
:: T_ypeObjectType
	= T_ypeConsSymbol !T_ypeName !T_ypeID [T_ypeObjectType]
	| PV_Placeholder (T_ypeObjectType -> T_ypeObjectType) T_ypeObjectType
	| UPV_Placeholder (T_ypeObjectType -> T_ypeObjectType) T_ypeObjectType
	| UV_Placeholder (T_ypeObjectType -> T_ypeObjectType) T_ypeObjectType
	
:: T_ypeName	:== {#Char}		

:: T_ypeID
	// internal dynamic
	= ModuleID DummyModuleID				// within application
	
	// external dynamic
	| RunTimeID !Int				//	id (both encoded/decoded dynamic rts)
	| LazyRunTimeID !Int !Int 		// id {dynamic_index (both rt and disk)} {disk library instance w.r.t. main dynamic}
	
_unify :: !T_ypeObjectType !T_ypeObjectType -> (Bool, [T_ypeObjectType])
_coerce :: !T_ypeObjectType !T_ypeObjectType -> (Bool, [T_ypeObjectType])

_undo_indirections :: a ![T_ypeObjectType] -> a

:: DynamicTemp = E.a: {
		value	:: a
	,	type	:: T_ypeObjectType
	}
	
:: GlobalDynamicInfo = {
	// general
		file_name		:: !String
	,	first_time		:: !Bool

	// block table
	,	id				:: !Int				// id from Dynamic Linker
	,	block_table		:: !BlockTable		
	,	graph_blocks	:: !{String}		// filepointer to start of graph
	,	graph_pointers	:: !{#.{Int}}
	
	// 
	,	diskid_to_runtimeid	:: !{#Int}		// conversion from DiskId (disguished as RunTimeId) to *real* runtimeID (library instances)
	,	di_disk_to_rt_dynamic_indices	:: !{#Int} // conversion from disk to runtime index for lazy dynamics
	,	di_dummy		:: !String
	,	di_type_redirection_table		:: !{#RunTimeIDW}

	}
// The # above ensure that no ARRAY node is inserted.

// force compiler to pass entire records instead of all entries
:: GlobalDynamicInfoDummy = {
		gdid			:: !GlobalDynamicInfo
	}

// BuildBlock
:: Pointer

build_lazy_block :: !Int !Int -> a //Pointer;

build_block :: !Int !GlobalDynamicInfoDummy -> a //Pointer /* algemeen: een stuk graaf */

//build_block :: !Int !GlobalDynamicInfoDummy -> Pointer /* algemeen: een stuk graaf */
// John: Pointer should be changed in BuildBlockResult. I think it should left as it is
// because normally the user doesn't see this.

instance EncodedDynamic String



// -----------------------------------------------------------------
:: Wrap a 
	= { 
		wrap_info		:: !a
	};

// aanpassen van gesharde type door alle library instanties		
:: *CopyGraphToStringArguments
	= {
		cgtsa_dynamic					:: Dynamic
	,	cgtsa_code_library_instances	:: !*{#Int}
	,	cgtsa_type_library_instances	:: !*{#Int}
	,	cgtsa_range_table				:: !{#Char}
	};
		
:: *CopyGraphToStringResults
	= {
		cgtsr_encoded_dynamic			:: !*{#Char}
	,	cgtsr_code_library_instances	:: !*{#T_ypeConsSymbolInfo}		// unused
	,	cgtsr_type_library_instances	:: !*{#Int}
	,	cgtsr_lazy_dynamic_references	:: !{#LazyDynamicReference}
	,	cgtsr_runtime_ids				:: !{#RunTimeIDW}
	}
	
:: T_ypeConsSymbolInfo
	= {
		tcsi_type_and_module_name		:: !String
	,	tcsi_rt_library_instance		:: !Int
	}	
	
class EncodedDynamic a
where 
	dynamic_to_string :: !Dynamic -> (!Bool,!*a)

:: *EncodedDynamic
	= { 
		ed_encoded_graph	:: !*{#Char}
	,	ed_dynamic_rts_info	:: !*{#Char}
	}

instance EncodedDynamic EncodedDynamic

string_to_dynamic :: !String -> (!Bool,!Dynamic)


init_dynamic :: !String !DynamicHeader !*a -> *(.Bool,.GlobalDynamicInfoDummy,*a) | BinaryDynamicIO a
//build_dynamic :: !Int !GlobalDynamicInfoDummy -> a //Dynamic


// zooi
copy_graph_to_string_OK :: !(Wrap CopyGraphToStringArguments) -> !(Wrap CopyGraphToStringResults);


